// crbug.com/40391360 -- Popup resize bug tester.
//
// Test 1: Capture innerWidth at script parse time (synchronous, top of body).
//         On buggy builds the popup opens at 25x25 so initialW will be tiny.
//
// Test 2: After 500ms, reveal a hidden section. The popup should grow.
//         Measure height before and after.

var initialW = window.innerWidth;
var initialH = window.innerHeight;

function $(id) { return document.getElementById(id); }

function runTest1() {
  var el = $('test1-actual');
  var card = $('test1-card');
  var icon = $('test1-icon');

  el.textContent = initialW + ' x ' + initialH;

  // The popup body is 380px wide. With scrollbar/frame the inner width
  // should be at least ~360.  On buggy builds it is 25.
  var pass = initialW >= 300;
  el.className = 'value ' + (pass ? 'ok' : 'bad');
  card.className = 'test-card ' + (pass ? 'pass' : 'fail');
  icon.textContent = pass ? '\u2705' : '\u274C';
  return pass;
}

function runTest2() {
  var heightBefore = window.innerHeight;
  $('test2-before').textContent = window.innerWidth + ' x ' + heightBefore;
  $('test2-before').className = 'value';

  // Reveal the dynamic section.
  $('dynamic-section').classList.add('show');

  // Wait for CSS transition + auto-resize round-trip.
  setTimeout(function () {
    var heightAfter = window.innerHeight;
    var afterEl = $('test2-after');
    afterEl.textContent = window.innerWidth + ' x ' + heightAfter;

    // The dynamic section adds ~120px. Allow some tolerance.
    var grew = heightAfter > heightBefore + 40;
    afterEl.className = 'value ' + (grew ? 'ok' : 'bad');

    var card = $('test2-card');
    var icon = $('test2-icon');
    card.className = 'test-card ' + (grew ? 'pass' : 'fail');
    icon.textContent = grew ? '\u2705' : '\u274C';

    showVerdict(grew);
  }, 600);

  return null; // async -- verdict set in timeout
}

var test1Result = false;

function showVerdict(test2Pass) {
  var bar = $('verdict');
  if (test1Result && test2Pass) {
    bar.textContent = '\u2705  ALL TESTS PASSED -- bug is fixed';
    bar.className = 'verdict-bar pass';
  } else {
    var parts = [];
    if (!test1Result) parts.push('initial size wrong');
    if (!test2Pass) parts.push('dynamic resize failed');
    bar.textContent = '\u274C  FAILED: ' + parts.join(', ');
    bar.className = 'verdict-bar fail';
  }
}

window.addEventListener('load', function () {
  // Small delay to let the compositor catch up (captures true initial state).
  setTimeout(function () {
    test1Result = runTest1();

    // Test 2 starts 500ms after load.
    setTimeout(runTest2, 500);
  }, 50);
});
